<?php  if ( ! defined('ABSPATH')) exit('No direct script access allowed');

$main_domain = 'https://xstore.8theme.com/demos/';
$versions = array(
    'default' => array(
        'title' => 'Default',
        'preview_url' => 'https://xstore.8theme.com/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
            'elementor_globals' => true,
        ),
        'plugins' => array( 'elementor', 'js_composer', 'woocommerce','wwp-vc-gmaps', 'contact-form-7', 'revslider', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all popular',
        'engine' => array('wpb', 'elementor')
    ),
    'agricultural' => array(
        'title' => 'Agricultural',
        'preview_url' => $main_domain . '2/agricultural/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'mailchimp' => false,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'static-blocks' => true,
            'testimonials' => false,
            'widgets' => true,
            'slider' => false,
            'home_page' => true,
            'multiple_headers' => false,
            'multiple_conditions' => false,
            'multiple_single_product' => false,
            'multiple_single_product_conditions' => false,
            'single_product_builder' => false,
        ),
        'plugins' => array('js_composer', 'woocommerce', 'mpc-massive', 'contact-form-7' ),
        'type' => 'demo',
        'filter' => 'all',
    ),
    'organic-cosmetics' => array(
        'title' => 'Organic-Cosmetics',
        'preview_url' => $main_domain . '2/organic-cosmetics/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'static-blocks' => true,
            'testimonials' => false,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
            'multiple_headers' => true,
            'multiple_conditions' => true,
            'multiple_single_product' => true,
            'multiple_single_product_conditions' => true,
            'single_product_builder' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7', 'revslider', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'ecotransport' => array(
        'title' => 'Eco Transport',
        'preview_url' => $main_domain . '2/ecotransport/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => true,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'widgets' => true,
            'slider' => 2,
            'home_page' => true,
            'multiple_headers' => true,
            'multiple_conditions' => true,
            'multiple_single_product' => true,
            'multiple_single_product_conditions' => true,
            'single_product_builder' => true,
        ),
        'plugins' => array('js_composer', 'woocommerce', 'mpc-massive', 'contact-form-7', 'revslider', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'eco-scooter' => array(
        'title' => 'Eco scooter',
        'preview_url' => $main_domain . '2/eco-scooter/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            // 'grid-builder' => true,
            //'mailchimp' => false,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'brands' => false,
            // 'projects' => false,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            //'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
            'single_product_builder' => true,
        ),
        'plugins' => array('js_composer', 'woocommerce', 'contact-form-7', 'revslider' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'niche-market' => array(
        'title' => 'Niche market',
        'preview_url' => $main_domain . '2/niche-market/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            // 'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            // 'projects' => false,
            //'smart-products' => true,
            'static-blocks' => true,
            // 'testimonials' => false,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => false,
            'home_page' => true,
            'single_product_builder' => true,
            'elementor_globals' => true,
        ),
        'plugins' => array(  'elementor', 'js_composer', 'woocommerce', 'contact-form-7', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all popular',
        'engine' => array('wpb', 'elementor')
    ),
    'decor' => array(
        'title' => 'Home decor',
        'preview_url' => $main_domain . '2/home-decor/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            //'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => true,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'projects' => false,            
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => false,            
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
            'elementor_globals' => true,
        ),
        'plugins' => array( 'elementor', 'js_composer', 'woocommerce','revslider','contact-form-7', 'mailchimp-for-wp' ),
        'engine' => array('wpb', 'elementor'),
        'type' => 'demo',
        'filter' => 'all',
    ),
    'minimalist-outfits' => array(
        'title' => 'Minimalist outfits',
        'preview_url' => $main_domain . '2/minimalist-outfits/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'projects' => false,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
        ),
        'plugins' => array(  'js_composer', 'woocommerce','revslider','contact-form-7', 'mailchimp-for-wp','sb-woocommerce-infinite-scroll' ),
        'type' => 'demo',
        'filter' => 'all',
    ),
    'language-courses' => array(
        'title' => 'Language courses',
        'preview_url' => $main_domain . '2/language-courses/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'content-presets' => true,            
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'brands' => false,
            'projects' => true,            
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => false,            
            'variations' => false,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => false,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all corporate',
    ),
    'fashion' => array(
        'title' => 'Fashion',
        'preview_url' => $main_domain . '2/fashion/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'brands' => false,
            //'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => false,
            'home_page' => true,
            'elementor_globals' => true,
        ),
        'plugins' => array( 'elementor', 'js_composer', 'woocommerce', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'engine' => array('elementor', 'wpb'),
        'filter' => 'all popular',
    ), 
    'artmaxy' => array(
        'title' => 'Artmaxy',
        'preview_url' => $main_domain . '2/artmaxy/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            // 'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => true,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            //'projects' => false,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => false,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => false,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'wwp-vc-gmaps', 'contact-form-7' ),
        'type' => 'demo',
        'filter' => 'all',
    ),   
    'lingerie' => array(
        'title' => 'Lingerie',
        'preview_url' => $main_domain . '2/lingerie/',
        'to_import' => array(
            'content' => true,
            //'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => true,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'brands' => false,
            //'projects' => false,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => false,
            'home_page' => true,
            'elementor_globals' => true,
        ),
        'plugins' => array( 'elementor', 'js_composer', 'woocommerce', 'wwp-vc-gmaps', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all popular',
        'engine' => array('wpb', 'elementor'),
    ),
    'babyland01' => array(
        'title' => 'BabyLand 01',
        'preview_url' => $main_domain . '2/babyland01/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => true,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            //'projects' => false,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => false,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'wocommerce', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all',
    ),
    'organic02' => array(
        'title' => 'Organic 02',
        'preview_url' => $main_domain . '2/organic02/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            //'projects' => false,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => false,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => false,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all',
    ),
    'organic01' => array(
        'title' => 'Organic 01',
        'preview_url' => $main_domain . '2/organic01/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => true,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            //'projects' => false,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => false,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => false,
            'home_page' => true,
            'elementor_globals' => true,
        ),
        'plugins' => array('elementor', 'js_composer', 'woocommerce', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp' ),
        'engine' => array('wpb', 'elementor'),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'electron01' => array(
        'title' => 'Electron 01',
        'preview_url' => $main_domain . '2/electron01/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => true,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            //'projects' => false,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => false,
            'home_page' => true,
        ),
        'plugins' => array('js_composer', 'woocommerce', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp'),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'electron02' => array(
        'title' => 'Electron 02',
        'preview_url' => $main_domain . '2/electron02/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            //'projects' => false,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => false,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'marseille02' => array(
        'title' => 'Marseille 02',
        'preview_url' => $main_domain . '2/marseille02/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            //'projects' => false,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => false,
            'home_page' => true,
            'elementor_globals' => true,
        ),
        'plugins' => array( 'elementor', 'js_composer', 'woocommerce', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all popular',
        'engine' => array('wpb', 'elementor'),
    ),
    'marseille01' => array(
        'title' => 'Marseille 01',
        'preview_url' => $main_domain . '2/marseille01/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            //'grid-builder' => false,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            //'projects' => false,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => false,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all',
    ),
    'designers' => array(
        'title' => 'Designers',
        'preview_url' => $main_domain . '2/designers/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => false,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'product_cats' => false,
            'brands' => false,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => false,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => 2,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7' ),
        'type' => 'demo',
        'filter' => 'all',
    ),
    'cleaning' => array(
        'title' => 'Cleaning',
        'preview_url' => $main_domain . '2/cleaning/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            //'grid-builder' => false,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            //'products' => false,
            //'projects' => false,
            //'smart-products' => true,
            'static-blocks' => true,
            //'testimonials' => false,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all',
    ),
    'baby-shop' => array(
        'title' => 'Baby Shop',
        'preview_url' => $main_domain . '2/baby-shop/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'brands' => false,
            //'projects' => false,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => false,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all',
    ),
    'carwash' => array(
        'title' => 'Car wash',
        'preview_url' => $main_domain . '2/carwash/',
        'to_import' => array(
            'content' => true,
            //'contact-forms' => false,
            //'grid-builder' => false,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'product_cats' => false,
            'brands' => false,
            //'projects' => false,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => false,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'delivery' => array(
        'title' => 'Delivery',
        'preview_url' => $main_domain . '2/delivery/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            //'grid-builder' => false,
            'mailchimp' => false,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            //'products' => false,
            //'projects' => false,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => false,
            //'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => false,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7' ),
        'type' => 'demo',
        'filter' => 'all popular catalog one-page',
    ),
    'photographer' => array(
        'title' => 'Photographer',
        'preview_url' => $main_domain . '2/photographer/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            //'grid-builder' => false,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'brands' => false,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => false,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'x-phone' => array(
        'title' => 'X-Phone',
        'preview_url' => $main_domain . '2/x-phone/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => false,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => false,
            //'projects' => false,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),    
    'plumbing' => array(
        'title' => 'Plumbing',
        'preview_url' => $main_domain . '2/plumbing/',
        'to_import' => array(
            'content' => true,
            //'contact-forms' => false,
            'grid-builder' => true,
            'mailchimp' => false,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'brands' => false,
            //'projects' => false,
            //'smart-products' => true,
            'static-blocks' => true,
            //'testimonials' => false,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'furniture2' => array(
        'title' => 'Furniture 2',
        'preview_url' => $main_domain . 'furniture2/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            //'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            //'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            //'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
//            'elementor_globals' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp' ),
//        'engine' => array('wpb', 'elementor'),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'interior' => array(
        'title' => 'Interior',
        'preview_url' => $main_domain . 'interior/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            //'grid-builder' => true,
            //'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'brands' => false,
            //'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            //'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'spa' => array(
        'title' => 'Spa',
        'preview_url' => $main_domain . 'spa/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            //'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'brands' => false,
            //'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            //'testimonials' => true,
            'variations' => false,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7' ),
        'type' => 'demo',
        'filter' => 'all popular catalog',
    ),
    'mobile' => array(
        'title' => 'Mobile Apps',
        'preview_url' => $main_domain . 'mobile/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            //'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'product_cats' => false,
            'brands' => false,
            //'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            //'testimonials' => true,
            'variations' => false,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => 2,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp','subscriptio' ),
        'type' => 'demo',
        'filter' => 'all popular catalog one-page',
    ),
    'burger' => array(
        'title' => 'Burger',
        'preview_url' => $main_domain . 'burger/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            //'grid-builder' => true,
            //'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'brands' => false,
            //'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => false,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'wedding' => array(
        'title' => 'Wedding',
        'preview_url' => $main_domain . 'wedding/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            //'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'brands' => false,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            //'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => 2,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'bicycle' => array(
        'title' => 'Bicycle',
        'preview_url' => $main_domain . 'bike/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            //'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'brands' => false,
            //'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            //'testimonials' => true,
            'variations' => false,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => 3,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all popular one-page',

    ),
    'furniture' => array(
        'title' => 'Furniture',
        'preview_url' => $main_domain . 'furniture/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => false,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'brands' => false,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
            'elementor_globals' => true,
        ),
        'plugins' => array( 'elementor', 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7' ),
        'engine' => array('wpb', 'elementor'),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'cosmetics' => array(
        'title' => 'Cosmetics',
        'preview_url' => $main_domain . 'cosmetics/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'engineer' => array(
        'title' => 'Engineer',
        'preview_url' => $main_domain . 'engineer/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => 4,
            'home_page' => true,
            'elementor_globals' => true,
        ),
        'plugins' => array( 'elementor', 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp' ),
        'engine' => array('wpb', 'elementor'),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'glasses' => array(
        'title' => 'Glasses',
        'preview_url' => $main_domain . 'glasses/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'kids' => array(
        'title' => 'Kids',
        'preview_url' => $main_domain . 'kids/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => 2,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'organic' => array(
        'title' => 'Organic',
        'preview_url' => $main_domain . 'organic/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            //'grid-builder' => true,
            // 'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'brands' => false,
            //'projects' => false,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => 2,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'drinks' => array(
        'title' => 'Drinks',
        'preview_url' => $main_domain . 'drinks/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'brands' => false,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => 2,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all popular catalog',
    ),
    'bakery' => array(
        'title' => 'Bakery',
        'preview_url' => $main_domain . 'bakery/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
//            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'brands' => false,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'hipster' => array(
        'title' => 'Hipster',
        'preview_url' => $main_domain . 'hipster/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            // 'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => 2,
            'home_page' => true,
            'elementor_globals' => true,
        ),
        'plugins' => array( 'elementor', 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7' ),
        'type' => 'demo',
        'filter' => 'all popular',
        'engine' => array('wpb', 'elementor'),
    ),
    'jewellery' => array(
        'title' => 'Jewellery',
        'preview_url' => $main_domain . 'jewellery/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            // 'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => false,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => 2,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'landing' => array(
        'title' => 'Landing',
        'preview_url' => $main_domain . 'landing-watch/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => false,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'brands'  => false,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => false,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => 2,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7' ),
        'type' => 'demo',
        'filter' => 'all popular catalog one-page',
    ),
    'hosting' => array(
        'title' => 'Hosting',
        'preview_url' => $main_domain . 'hosting/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'brands' => false,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => 2,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'subscriptio' ),
        'type' => 'demo',
        'filter' => 'all popular catalog one-page corporate',
    ),
    'electronics' => array(
        'title' => 'Electronics',
        'preview_url' => $main_domain . 'electronics/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'brands' => false,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => 2,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),    
    'sushi' => array(
        'title' => 'Sushi Restaurant',
        'preview_url' => $main_domain . 'sushi/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => false,
            'brands' => false,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7' ),
        'type' => 'demo',
        'filter' => 'all popular catalog',
    ),
    'gym' => array(
        'title' => 'Gym',
        'preview_url' => $main_domain . 'gym/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'brands' => false,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => 2,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'corporate' => array(
        'title' => 'Corporate',
        'preview_url' => $main_domain . 'corporate/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => false,
            'brands' => false,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all popular catalog corporate',
    ),  
    'finances' => array(
        'title' => 'Finances',
        'preview_url' => $main_domain . 'finances/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'brands' => false,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => false,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
            'elementor_globals' => true,
        ),
        'plugins' => array( 'elementor', 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp'),
        'engine' => array('wpb', 'elementor'),
        'type' => 'demo',
        'filter' => 'all popular catalog corporate',
    ),
     'marketing' => array(
        'title' => 'Marketing',
        'preview_url' => $main_domain . 'marketing/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => false,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all popular corporate',
    ), 
     'lawyer' => array(
        'title' => 'Lawyer',
        'preview_url' => $main_domain . 'lawyer/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => false,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'brands' => false,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => false,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
            'elementor_globals' => true
        ),
        'plugins' => array( 'elementor', 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7' ),
        'type' => 'demo',
        'engine' => array('elementor', 'wpb'),
        'filter' => 'all popular corporate',
    ),
    'flowers' => array(
        'title' => 'Flowers',
        'preview_url' => $main_domain . 'flowers/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            // 'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'brands' => false,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'handmade' => array(
        'title' => 'Handmade',
        'preview_url' => $main_domain . 'handmade/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            // 'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => 2,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'medical' => array(
        'title' => 'Medical',
        'preview_url' => $main_domain . 'medical/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'minimal' => array(
        'title' => 'Minimal',
        'preview_url' => $main_domain . 'minimal/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => false,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'brands' => false,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'concert' => array(
        'title' => 'Concert',
        'preview_url' => $main_domain . 'concert/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            // 'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => false,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'animals' => array(
        'title' => 'Animals',
        'preview_url' => $main_domain . 'animals/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => false,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'underwear' => array(
        'title' => 'Underwear',
        'preview_url' => $main_domain . 'underwear/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'brands' => false,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => false,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'books' => array(
        'title' => 'Books',
        'preview_url' => $main_domain . 'books/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => false,
            'brands' => false,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => 4,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'makeup' => array(
        'title' => 'Makeup',
        'preview_url' => $main_domain . 'makeup/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            // 'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'tea' => array(
        'title' => 'Tea',
        'preview_url' => $main_domain . 'tea/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'freelance' => array(
        'title' => 'Freelance',
        'preview_url' => $main_domain . 'freelance/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            // 'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'brands' => false,
            'product_cats' => false,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => false,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7' ),
        'type' => 'demo',
        'filter' => 'all popular catalog one-page corporate',
    ),
    'shoes' => array(
        'title' => 'Shoes',
        'preview_url' => $main_domain . 'shoes/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            // 'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'brands' => false,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
            'elementor_globals' => true,
        ),
        'plugins' => array( 'elementor', 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7' ),
        'type' => 'demo',
        'filter' => 'all popular',
        'engine' => array('wpb', 'elementor'),
    ),
    'cocktails' => array(
        'title' => 'Cocktails',
        'preview_url' => $main_domain . 'cocktails/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'brands' => false,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => false,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => 2,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all popular catalog',
    ),
    'barbershop' => array(
        'title' => 'Barbershop',
        'preview_url' => $main_domain . 'barbershop/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => false,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all popular catalog',
    ),
    'business' => array(
        'title' => 'Business',
        'preview_url' => $main_domain . 'business/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => false,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => false,
            'projects' => false,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => false,
            'home_page' => true,
            'elementor_globals' => true,
        ),
        'plugins' => array( 'elementor', 'js_composer', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7' ),
        'type' => 'demo',
        'engine' => array('elementor', 'wpb'),
        'filter' => 'all popular catalog corporate',
    ),
    'games' => array(
        'title' => 'Games',
        'preview_url' => $main_domain . 'games/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'brands' => false,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => false,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7', 'mailchimp-for-wp' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'typography' => array(
        'title' => 'Typography',
        'preview_url' => $main_domain . 'typography/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            // 'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'product_cats' => false,
            'brands' => false,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => false,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7' ),
        'type' => 'demo',
        'filter' => 'all popular one-page',
    ),
    'pizza' => array(
        'title' => 'Pizza',
        'preview_url' => $main_domain . 'pizza/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            // 'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'brands' => false,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => 3,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider', 'mpc-massive', 'wwp-vc-gmaps', 'contact-form-7' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'dark' => array(
        'title' => 'Dark',
        'preview_url' => $main_domain . 'dark/',
        'to_import' => array(
            'content' => true,
            'contact-forms' => true,
            'grid-builder' => true,
            'mailchimp' => true,
            'media' => true,
            'menu' => true,
            'fonts' => false,
            'options' => true, 
            'pages' => true,
            'posts' => true,
            'products' => true,
            'projects' => true,
            //'smart-products' => true,
            'static-blocks' => true,
            'testimonials' => true,
            'variations' => true,
            //'vc-templates' => true,
            'widgets' => true,
            'slider' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'woocommerce', 'revslider' ),
        'type' => 'demo',
        'filter' => 'all popular',
    ),
    'coming-soon-red' => array(
        'title' => 'Coming soon red',
        'preview_url' => $main_domain . 'coming-soon-red/',
        'to_import' => array(
            'pages' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer'),
        'type' => 'demo'
    ),
    'coming-soon-dark' => array(
        'title' => 'Coming soon dark',
        'preview_url' => $main_domain . 'coming-soon-black/',
        'to_import' => array(
            'pages' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer'),
        'type' => 'demo'
    ),
    'coming-soon-white' => array(
        'title' => 'Coming soon white',
        'preview_url' => $main_domain . 'coming-soon-white/',
        'to_import' => array(
            'pages' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer'),
        'type' => 'demo'
    ),
    'coming-soon-flat' => array(
        'title' => 'Coming soon flat',
        'preview_url' => $main_domain . 'coming-soon-flat/',
        'to_import' => array(
            'pages' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer'),
        'type' => 'demo'
    ),
    'coming-soon-xstore' => array(
        'title' => 'Coming soon xstore',
        'preview_url' => $main_domain . 'coming-soon-xstore/',
        'to_import' => array(
            'pages' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer'),
        'type' => 'demo'
    ),
    'coming-soon-we-are-coming-soon' => array(
        'title' => 'We are coming soon',
        'preview_url' => $main_domain . '2/we-are-coming-soon/',
        'to_import' => array(
            'pages' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'mpc-massive'),
        'type' => 'demo'
    ),
    'coming-soon-great-things-are-coming' => array(
        'title' => 'Great things are coming',
        'preview_url' => $main_domain . '2/great-things-are-coming/',
        'to_import' => array(
            'pages' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'mpc-massive'),
        'type' => 'demo'
    ),    
    'coming-soon-modern-x-coming' => array(
        'title' => 'Modern X coming',
        'preview_url' => $main_domain . '2/modern-x-coming/',
        'to_import' => array(
            'pages' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'mpc-massive'),
        'type' => 'demo'
    ),
    'coming-soon-space-coming' => array(
        'title' => 'Space coming',
        'preview_url' => $main_domain . '2/space-coming/',
        'to_import' => array(
            'pages' => true,
            'home_page' => true,
        ),
        'plugins' => array( 'js_composer', 'mpc-massive'),
        'type' => 'demo'
    ),
);

$popular_demos = array(
    'default',
    'niche-market',
    'marseille02',
    'electronics',
    'animals',
    'engineer',
    'organic01',
    'bicycle',
    'landing',
    'electron01',
    'furniture',
    'hipster',
    'decor',
    'minimalist-outfits',
    'electron02',
    'lingerie',
    'glasses',
    'x-phone',
    'electronics',
    'fashion',
    'interior',
    'minimal',
    'mobile',
    'underwear',
    'burger',
    'dark',
    'carwash',
    'delivery',
    'photographer',
    'typography',
    'games',
    'business',
    'barbershop',
    'cocktails',
    'organic',
    'shoes',
    'freelance',
    'plumbing',
    'furniture2',
    'spa',
    'pizza',
    'tea',
    'books',
    'jewellery',
    'corporate',
    'gym',
    'makeup',
    'marketing',
    'wedding',
    'kids',
    'sushi',
    'handmade',
    'hosting',
    'medical',
    'finances',
    'concert',
    'flowers',
    'bakery',
    'lawyer',
    'cosmetics',
    'drinks',
);

$popular = $catalog = $one_page = $corporate = -1;
foreach ($versions as $key => $value) {
    $versions[$key]['orders'] = array(
        'popular' => $popular,
        'catalog' => $catalog,
        'one-page' => $one_page,
        'corporate' => $corporate
    );
    $popular++;
    $catalog++;
    $one_page++;
    $corporate++;
}

$popular = -1;
foreach ($popular_demos as $key) {
    $versions[$key]['orders']['popular'] = $popular;
    $popular++;
}
return $versions;