/**
 * Description
 *
 * @package    oldHeader.js
 * @since      6.3.4
 * @author     stas
 * @link       http://xstore.8theme.com
 * @license    Themeforest Split Licence
 */
var oldHeader;

;(function ($) {

    "use strict";

    var et_global;

    oldHeader = {
        init: function () {
            et_global = {
                'w_width': $(window).width(),
                'w_height': $(window).height(),
                'mob_menu_opened': false,
                'top_panel_opened': false,
                'fixed_header': etOldHeaderConfig['layoutSettings']['fixed_header_type'] == 'fixed',
                'header_resizing': false,
                'shop_navbar': $('body').hasClass('shop-top-bar'),
                'classes': {
                    'skeleton': etOldHeaderConfig.et_global.classes.skeleton,
                    'mfp': etOldHeaderConfig.et_global.classes.mfp
                }
            };
            this.helpers();
            this.fixedHeader();
            this.navMenuSmart();
            this.searchform();
            this.mobileMenu();
            this.newsletterPopup();
            this.topPanel();
            this.ajaxSearch();
            this.hamburgerIcon();
            this.scrollMenu();
            this.NavbarHeader();
            if (etOldHeaderConfig['woocommerceSettings']['is_woocommerce']) {
                this.wishlist();
            }
            setTimeout(function () {
                $('body').addClass('cart-widget-show');
            }, 1000);
        },

        // must have
        helpers: function () {
            $(window).resize(function () {
                et_global['w_width'] = $(window).width();
                et_global['w_height'] = $(window).height();
            });
        },

        // header not builder modules
        fixedHeader: function () {

            if ($.inArray(etOldHeaderConfig['layoutSettings']['fixed_header_type'], ['fixed', 'sticky']) < 0) return;
            if ($('body').hasClass('et-vertical-fixed') && et_global['w_width'] > 992) return;

            var header = $('.header-wrapper'),
                startOffset = 120;

            function et_fixed_header_content() {
                var logo = header.find('.header-logo').html(),
                    menu = header.find('.menu-wrapper').first(),
                    menuClass = menu.attr('class'),
                    menuRight = header.find('.menu-wrapper-right'),
                    navbar = header.find('.navbar-header').html(),
                    menuBtn = header.find('.navbar-toggle').html(),
                    color = $('.page-wrapper').data('fixed-color'),
                    menuHtml;
                // Do it for non standard navbar
                if (et_global['shop_navbar']) {
                    navbar = oldHeader.NavbarHeader('fixed');
                }

                if (menuRight.length > 0) {
                    menuHtml = menu.html() + menuRight.html();
                } else {
                    menuHtml = menu.html();
                }

                if ($('.woocommerce-mini-cart__buttons').hasClass('wcppec-cart-widget-spb')) {
                    navbar = navbar.replace($('.wcppec-cart-widget-spb').html(), '');
                }

                // Check values for "Toolset Layouts" plugin
                if (logo == null) logo = '';
                if (menuHtml == null) menuHtml = '';
                if (navbar == null) navbar = '';
                if (menuBtn == null) menuBtn = '<span class="sr-only">Menu</span><span class="icon-bar"></span><span class="icon-bar"></span><span class="icon-bar"></span>';

                var fixedHeaderHtml = '<div class="fixed-header header-color-' + color + '"><div class="container"><div class="container-wrapper"><div class="navbar-toggle">' + menuBtn + '</div><div class="header-logo">' + logo + '</div><div class="' + menuClass + '">' + menuHtml + '</div><div class="navbar-header">' + navbar + '</div></div></div></div>';
                return fixedHeaderHtml;
            }

            var fixedHeaderHtml = et_fixed_header_content();
            header.after(fixedHeaderHtml);

            if (et_global['w_width'] < 768) {
                startOffset = 80;
            }

            if (et_global['fixed_header']) {
                $(window).scroll(function () {

                    if ($(this).scrollTop() > startOffset) {
                        $('.fixed-header').addClass('fixed-enabled');
                    } else {
                        $('.fixed-header').removeClass('fixed-enabled');
                    }

                });
            } else {
                if ($('body').hasClass('et-header-sticky')) {
                    var previousScroll = 0;
                    $(window).scroll(function () {
                        var currentScroll = $(this).scrollTop();

                        // sticky header
                        if ((currentScroll < previousScroll) && (currentScroll > startOffset)) {
                            $('.fixed-header').addClass('sticky-header-enabled');
                        } else {
                            $('.fixed-header').removeClass('sticky-header-enabled');
                        }

                        previousScroll = currentScroll;
                    });
                }
            }
        },

        navMenuSmart: function () {
            if ($.inArray(etOldHeaderConfig['layoutSettings']['header_type'], ['vertical', 'vertical2', 'hamburger-icon']) > -1)
                return;

            if (window.innerWidth > 991 && ($('body').hasClass('header-smart-responsive'))) {
                $('.menu-wrapper > .menu-main-container .menu').append('<li class="more menu-more item-design-dropdown"><div class="menu-more-toggle"><span></span></div><div class="nav-sublist-dropdown"><div class="container"><ul></ul></div></div></li>');
                $('.header-wrapper').addClass('header-resizing');
                et_global['header_resizing'] = true;
                $(document).on('click', '.menu-more', function () {
                    if ($(this).hasClass('opened')) {
                        $(this).removeClass('opened');
                    } else {
                        $(this).addClass('opened');
                    }
                });
                var calcWidth = function () {
                    if (window.innerWidth < 993) return;
                    // Prefix '_f' for fixed headers
                    var fixed_check = false,
                        double_header = false,
                        secondaryMenu = false,
                        items_f,
                        availablespace_h;

                    var menu_wrapper = $('.header-wrapper .menu-wrapper');

                    var each_item_of = $(menu_wrapper).find(' .menu > .menu-item');
                    if ($.inArray(etOldHeaderConfig['layoutSettings']['fixed_header_type'], ['fixed', 'sticky']) > -1) {
                        fixed_check = true;
                        each_item_of = $('.header-wrapper .menu-wrapper .menu > .menu-item, .fixed-header .menu-wrapper .menu > .menu-item');
                    }

                    if ($('body').hasClass('et-secondary-menu-on')) {
                        secondaryMenu = true;
                    }

                    $(each_item_of).each(function () {
                        $(this).attr('data-width', $(this).outerWidth(true));
                    });

                    var morewidth_f = $('.fixed-header .menu-wrapper .menu .more').outerWidth(true);
                    var morewidth = $(menu_wrapper).find(' .menu .more').outerWidth(true);
                    var extra_space = morewidth,
                        extra_space_f = morewidth_f;

                    // Save the origin size of toggle into the attribute just one time
                    $(document).one('ready', function () {
                        $('.header-wrapper .menu-main-container .menu .more').attr('data-width', morewidth);
                        if (fixed_check) {
                            $('.fixed-header .menu-main-container .menu .more').attr('data-width', morewidth_f);
                        }
                    });

                    //var availablespace = $('nav').outerWidth(true) - morewidth;
                    var extra_space = $(menu_wrapper).find(' .menu .more').attr('data-width'),
                        extra_space_f = $('.fixed-header .menu-main-container .menu .more').attr('data-width'),
                        availablespace_h = $('.header-wrapper .menu-wrapper > .menu-main-container').outerWidth(true) - extra_space * 1.5;

                    if (etOldHeaderConfig['layoutSettings']['header_type'] == 'xstore') {
                        availablespace_h = availablespace_h - extra_space / 2; // only for these header types
                    } else if (etOldHeaderConfig['layoutSettings']['header_type'] == 'double-menu') {

                        double_header = true;
                        availablespace_h = [];
                        var i = 0;
                        $(menu_wrapper).each(function () {
                            availablespace_h.push($(this).outerWidth(true) - extra_space * 1.5);
                            i += 1;
                        });

                        var children_width = 0;
                        $('.menu-wrapper:eq(' + i + ')').next('.navbar-header').children().each(function () {
                            children_width += $(this).outerWidth(true);
                        });

                        availablespace_h[availablespace_h.length - 1] = $('.menu-wrapper:eq(' + i + ')').outerWidth(true) - Math.ceil(children_width) - extra_space * 1.5;

                    } else if (etOldHeaderConfig['layoutSettings']['header_type'] == 'advanced' && secondaryMenu) {
                        availablespace_h = $('.header-wrapper .menu-inner').outerWidth(true) - $(menu_wrapper).prevAll().outerWidth(true) - extra_space * 2;
                    } else if ($.inArray(etOldHeaderConfig['layoutSettings']['header_type'], ['center3', 'standard']) > -1 && secondaryMenu) {
                        availablespace_h = $('.header-wrapper .menu-inner').outerWidth(true) - $(menu_wrapper).find('> .menu-main-container').prevAll().outerWidth(true) - $(menu_wrapper).nextAll().outerWidth(true) - extra_space * 2;
                    } else if ($.inArray(etOldHeaderConfig['layoutSettings']['header_type'], ['center3', 'standard', 'advanced']) > -1) {
                        availablespace_h = $('.header-wrapper .menu-inner').outerWidth(true) - $(menu_wrapper).nextAll().outerWidth(true) - extra_space * 2;
                    }

                    if (availablespace_h < 0) {
                        return;
                    }

                    /* check the length of all items */
                    function et_checking_h() {
                        var navwidth = 0;

                        if (double_header) {

                            var i = 0;
                            var array = [];

                            // For multiple menu in header let's count the width of each one
                            $(menu_wrapper).each(function () {
                                var navwidth = 0;
                                $(this).find('.menu > .menu-item').each(function () {
                                    navwidth += $(this).data('width');
                                });
                                array.push(navwidth);
                                i += 1;
                            });
                            navwidth = array;

                        } else {
                            $(menu_wrapper).find('> .menu-main-container .menu > .menu-item').each(function () {
                                navwidth += $(this).data('width');
                            });
                        }
                        return navwidth;
                    }

                    /* remove item and place in submenu if their width is more than available*/
                    function et_removing_h() {
                        var navwidth = et_checking_h();
                        // if ( navwidth < 0 ) { return; }

                        if ($.isArray(navwidth)) {
                            var i = 0; // for array
                            var j = 1; // for menu number
                            $($(menu_wrapper)).each(function () {

                                // Remove items in each menu of header and add on resize if there is enought space
                                function et_multiple_removing() {
                                    navwidth = et_checking_h();
                                    if (navwidth[i] > availablespace_h[i] || navwidth[i] == availablespace_h[i]) {
                                        var lastitem = $('.menu-wrapper:eq(' + (j) + ') > .menu-main-container .menu > .menu-item').last();
                                        lastitem.prependTo($('.menu-wrapper:eq(' + (j) + ') > .menu-main-container .menu .more ul').first());
                                        et_multiple_removing();
                                    } else {
                                        var firstItem = $('.menu-wrapper:eq(' + (j) + ') > .menu-main-container .menu .more ul').first().find('.menu-item').first();
                                        var firstItemWidth = firstItem.data('width');
                                        if ((navwidth[i] + firstItemWidth) < availablespace_h[i]) {
                                            firstItem.insertBefore($('.menu-wrapper:eq(' + (j) + ') > .menu-main-container .menu .more'));
                                        }
                                    }
                                }

                                et_multiple_removing();
                                i += 1;
                                j += 1;
                            });
                        } else {
                            if (navwidth > availablespace_h || navwidth == availablespace_h) {
                                var lastitem = $(menu_wrapper).find('.menu > .menu-item').last();
                                lastitem.prependTo($(menu_wrapper).find('.menu .more ul').first());
                                et_removing_h();
                            } else {
                                var firstItem = $(menu_wrapper).find('.menu .more ul').first().find('.menu-item').first();
                                var firstItemWidth = firstItem.data('width');
                                if ((navwidth + firstItemWidth) < availablespace_h) {
                                    firstItem.insertBefore($('.header-wrapper .menu .more'));
                                }
                            }
                        }
                    }

                    et_removing_h();
                    if (fixed_check) {
                        var availablespace_f = $('.fixed-header .menu-wrapper > .menu-main-container').outerWidth(true) - extra_space_f * 2; // extra space ( morewidth_f * 2), because sometimes there is enought space but toggle jumps down ( because of padd )
                        if (double_header) {
                            var availablespace_f = $('.fixed-header .menu-wrapper').outerWidth(true) - extra_space_f * 2;
                            var toggle_check = $('.fixed-header').find('.menu-main-container:eq(1)').find('.more ul .menu-item').length;
                            availablespace_f = availablespace_f - extra_space_f / 2;
                            if (toggle_check < 0 || toggle_check == 0) {
                                $('.fixed-header').find('.menu-main-container:eq(1)').find('.more').remove();
                            }
                        }
                        var et_checking_f = function () {
                            var navwidth = 0;
                            $('.fixed-header .menu-wrapper > .menu-main-container .menu > .menu-item').each(function () {
                                navwidth += $(this).outerWidth(true);
                            });
                            return navwidth;
                        }
                        var et_removing_f = function () {
                            var navwidth = et_checking_f();
                            if (navwidth < 0) {
                                return;
                            }
                            if (navwidth > availablespace_f || navwidth == availablespace_f) {
                                var lastitem = $('.fixed-header .menu-wrapper .menu > .menu-item').last();
                                lastitem.prependTo($('.fixed-header .menu-wrapper .menu .more ul').first());
                                et_removing_f();
                            } else {
                                var firstItem = $('.fixed-header .menu-wrapper .menu .more ul').first().find('.menu-item').first();
                                var firstItemWidth = firstItem.data('width');
                                if ((navwidth + firstItemWidth) < availablespace_f) {
                                    firstItem.insertBefore($('.fixed-header .menu .more'));
                                }
                            }
                        }
                        et_removing_f();

                        header_toggle('.fixed-header .menu-wrapper .menu .more');
                    }

                    // header_toggle - remove or show more toggle

                    function header_toggle(header) {
                        if ($(header).find('ul .menu-item').length > 0) {
                            if ($(header).hasClass('hidden')) {
                                $(header).removeClass('hidden');
                            }
                        } else {
                            if ($(header).hasClass('hidden') === false) {
                                $(header).addClass('hidden');
                            }
                        }
                    }

                    // if double header let's check each menu for overcount items in it

                    if (double_header) {
                        var i = 0;
                        $.each($(menu_wrapper), function () {
                            header_toggle($('.header-wrapper .menu-wrapper:eq(' + i + ')').find('.menu .more'));
                            i += 1;
                        });
                    } else {
                        header_toggle('.header-wrapper .menu-wrapper .menu .more');
                    }
                }
                // end calcWidth

                $(window).on('load resize', function () {
                    var header_wrap = $('.header-wrapper');
                    var s_height = $(header_wrap).height();
                    if (et_global['header_resizing']) {
                        if (header_wrap.attr('data-height')) {
                            calcWidth();
                            var e_height = header_wrap.height();
                            header_wrap.css('height', header_wrap.attr('data-height'));
                            // if ( header_wrap.attr('data-end-height') ) {
                            // header_wrap.animate({
                            //     height: header_wrap.attr('data-end-height')
                            // }, 300);
                            // header_wrap.removeAttr('data-height').removeAttr('data-end-height');
                            // setTimeout(function(){
                            //     header_wrap.removeClass('header-resizing').attr('style', '');
                            //     et_global['header_resizing'] = false;
                            // }, 1500);
                            // }
                            // else {
                            // header_wrap.attr('data-end-height', e_height);
                            header_wrap.animate({
                                height: e_height
                            }, 300);
                            header_wrap.removeAttr('data-height');
                            setTimeout(function () {
                                header_wrap.removeClass('header-resizing').attr('style', '').addClass('header-resized');
                                et_global['header_resizing'] = false;
                            }, 1500);
                            // }
                        } else {
                            header_wrap.attr('data-height', s_height);
                            calcWidth();
                        }
                    } else {
                        calcWidth();
                    }

                });
            } // end check for window width
        },

        searchform: function () {
            // **********************************************************************//
            // ! Search form
            // **********************************************************************//

            var search = $('.header-search');

            search.each(function () {
                var s = $(this);

                s.on('click', '.search-btn', function (e) {
                    e.preventDefault();

                    if (search.hasClass('search-open')) {
                        closeSearch();
                    } else {
                        openSearch();
                    }
                });

                $('body').on("click", ".page-wrapper", function (event) {

                    if (!$(event.target).hasClass('header-search') && $(event.target).closest('.header-search').length) return;

                    if (s.hasClass('search-open')) {
                        closeSearch();
                    }
                });

                var openSearch = function () {
                    s.closest($('.navbar-header')).addClass('search-active');
                    s.parents('.header-wrapper, .fixed-header').addClass('search-now-opened');
                    s.addClass('search-open');
                    s.find('.search-form-wrapper').fadeIn(200);
                    s.find('input[type="text"]').focus();
                };

                var closeSearch = function () {
                    s.parents('.header-wrapper, .fixed-header').removeClass('search-now-opened');
                    s.removeClass('search-open');
                    s.find('.search-form-wrapper').fadeOut(200);
                    s.closest($('.navbar-header')).removeClass('search-active');
                };
            });

        },

        mobileMenu: function () {
            // **********************************************************************//
            // ! Mobile Menu
            // **********************************************************************//
            $(document).on('click', '.navbar-toggle', function () {
                if (et_global['mob_menu_opened']) {
                    closeMenu();
                } else {
                    openMenu();
                }
            });

            var navList = $('.mobile-menu-wrapper .menu');
            var opener = '<span class="open-child"></span>';

            navList.find('li:has(ul)', this).each(function () {
                var $this = $(this),
                    backtext,
                    allLink;
                $this.prepend(opener);

                backtext = etOldHeaderConfig.menuBack;
                allLink = $this.find('> a').clone();
                $this.find('> ul').prepend('<li class="menu-show-all">' + allLink.wrap('<div>').parent().html() + '</li>');
                $this.find('> ul').prepend('<li class="menu-back"><a href="javascript:void(0);">' + backtext + '</a></li>');
            });

            navList.on('click', '.open-child, .open-child+a', function (e) {
                e.preventDefault();
                if ($(this).parent().hasClass('over')) {
                    $(this).parent().removeClass('over');
                    if ($(this).parent().hasClass('item-level-0')) {
                        navList.removeClass('moves-out');
                    }
                } else {
                    $(this).parent().parent().find('>li.over').removeClass('over');
                    $(this).parent().addClass('over');
                    if ($(this).parent().hasClass('item-level-0')) {
                        navList.addClass('moves-out');
                    }
                }
            });

            navList.on('click', '.menu-back', function () {
                var $parent = $(this).parent().parent();
                if ($parent.hasClass('over')) {
                    $parent.removeClass('over');
                    if ($parent.hasClass('item-level-0')) {
                        navList.removeClass('moves-out');
                    }
                }
            });

            $('.template-content').on('click', function (event) {
                if (!$(event.target).closest('.mobile-menu-wrapper').length && !$(event.target).closest('.navbar-toggle').length) {
                    if (et_global['mob_menu_opened']) {
                        closeMenu();
                    }
                }
            });

            $('.mobile-menu-wrapper .open-child').on('click touchstart', function (event) {
                setTimeout(function () {
                    $('.navbar-collapse').animate({scrollTop: 0}, 600);
                }, 500);
            });

            function openMenu() {
                $('body').removeClass('mobile-menu-closed').addClass('mobile-menu-opened');
                $('.navbar-toggle').addClass('show-nav');
                et_global['mob_menu_opened'] = true;
            }

            function closeMenu() {
                $('.navbar-toggle').removeClass('show-nav');
                $('body').removeClass('mobile-menu-opened').addClass('mobile-menu-closed');
                et_global['mob_menu_opened'] = false;
            }

        },

        newsletterPopup: function () {
            var et_popup_closed = $.cookie('etheme_popup_closed');
            $('.etheme-popup').magnificPopup({
                items: {
                    src: '#etheme-popup-wrapper',
                    type: 'inline'
                },
                removalDelay: 300, //delay removal by X to allow out-animation
                callbacks: {
                    beforeOpen: function () {
                        this.st.mainClass = 'mfp-zoom-out';
                        $('body').addClass('newsletter-open');
                        $('html').addClass(et_global['classes']['mfp']);
                    },
                    beforeClose: function () {
                        //if($('#showagain:checked').val() == 'do-not-show')
                        $.cookie('etheme_popup_closed', 'do-not-show', {expires: 1, path: '/'});
                        setTimeout(function () {
                            $('body').removeClass('newsletter-open');
                        }, 300)
                    },
                    afterClose: function () {
                        $('html').removeClass(et_global['classes']['mfp']);
                    }
                }
            });
            if (et_popup_closed !== 'do-not-show' && $('.etheme-popup').length > 0) {
                if ($('body').hasClass('scroll-popup')) {
                    var localShown = false;
                    $(window).scroll(function () {
                        if (localShown) return false;
                        if ($(document).scrollTop() > $(document).height() - et_global['w_height'] - 300) {
                            var delay = $('#etheme-popup-holder').attr('data-delay');
                            setTimeout(function () {
                                $('.etheme-popup').magnificPopup('open');
                            }, delay);
                            localShown = true;
                        }
                    });
                } else if ($('body').hasClass('open-popup')) {
                    var delay = $('#etheme-popup-holder').attr('data-delay');
                    setTimeout(function () {
                        $('.etheme-popup').magnificPopup('open');
                    }, delay);
                }
            }
        },

        topPanel: function () {
            // **********************************************************************//
            // ! Top panel
            // **********************************************************************//
            $('.top-panel-open').click(function () {
                if (et_global['top_panel_opened']) {
                    closePanel();
                } else {
                    openPanel();
                }
            });

            $('.close-panel').click(function () {
                $('.template-content').click();
            });

            function openPanel() {
                $('body').removeClass('top-panel-closed').addClass('top-panel-opened');
                et_global['top_panel_opened'] = true;

                setTimeout(function () {
                    $('.template-content').one('click', function (event) {
                        if (et_global['top_panel_opened']) {
                            closePanel();
                        }
                    });
                }, 1);
            }

            function closePanel() {
                $('body').removeClass('top-panel-opened').addClass('top-panel-closed');
                et_global['top_panel_opened'] = false;
            }
        },

        ajaxSearch: function () {
            var form = $('.header-wrapper .ajax-search-form'),
                click = false,
                request = false;

            form.on('keyup', 'input[type="text"]', function () {

                var thisForm = $(this).parents('.ajax-search-form'),
                    results = thisForm.find('.ajax-results'),
                    s = thisForm.find('input[type="text"]').val();

                if (s.length < 1 && !click) {
                    results.html('').hide();
                    return;
                }

                var cat = $(this).parents('.ajax-search-form').find('select').val();
                if (!cat) cat = 0;

                request = $.ajax({
                    url: etOldHeaderConfig.ajaxurl,
                    method: 'POST',
                    data: {
                        'action': 'et_ajax_search',
                        's': s,
                        'cat': cat
                    },
                    dataType: 'json',
                    beforeSend: function () {
                        thisForm.addClass('ajax-in-action');
                        results.hide();
                    },
                    complete: function () {
                        thisForm.removeClass('ajax-in-action');
                        click = true;
                    },
                    success: function (response) {
                        results.html(response.html).css('display', 'flex');
                    },
                    error: function () {
                    }
                });

                $('body').on('click', function (event) {
                    if (!$(event.target).hasClass('search-form-wrapper') && $(event.target).closest('.search-form-wrapper').length) return;
                    results.hide();
                });

            });

        },

        hamburgerIcon: function () {
            $(document).on('click', '.hamburger-icon', function () {
                $('body').toggleClass('fullscreen-menu-opened');
            });

            // ! Close menu for vertical header types
            $('.content-page, footer.footer, .et-footers-wrapper, .header-wrapper.vertical-mod, .page-heading').on('click', function (e) {
                if ($('body').is('.fullscreen-menu-opened.et-vertical-fixed')) {
                    $('body').toggleClass('fullscreen-menu-opened');
                }
            });

            var navList = $('.fullscreen-menu-container .menu'),
                opener = '<span class="open-child">(open)</span>';

            navList.find('li:has(ul)', this).each(function () {
                var $this = $(this);
                $this.find(' > a').wrap('<div class="inside" />').parent().append(opener);
            });

            navList.on('click', '.open-child', function () {
                if ($(this).parent().hasClass('over')) {
                    $(this).parent().removeClass('over').parent().find(' > .nav-sublist-dropdown, > .nav-sublist').stop().slideUp(300);
                } else {
                    $(this).parent().addClass('over').parent().find(' > .nav-sublist-dropdown, > .nav-sublist').stop().slideDown(300);
                }
            });

            if (navList.parent().hasClass('one-page-menu')) {
                navList.on('click', '.item-link', function () {
                    $('body').toggleClass('fullscreen-menu-opened');
                });
            }
        },

        scrollMenu: function () {
            var scrollMenuInside = jQuery('.header-vertical .item-design-mega-menu > .nav-sublist-dropdown > .container, .header-vertical2 .item-design-mega-menu > .nav-sublist-dropdown > .container');

            scrollMenuInside.each(function () {
                var $this = jQuery(this),
                    innerContent = $this.find('> ul');

                $this.on('mousemove', function (e) {
                    var parentOffset = $this.offset();

                    var relY = e.pageY - parentOffset.top;

                    var deltaHeight = innerContent.outerHeight() - $this.height();

                    if (deltaHeight < 0) return;

                    var percentY = relY / $this.height(),
                        margin = 0;

                    if (percentY <= 0) {
                        margin = 0;
                    } else if (percentY >= 1) {
                        margin = -deltaHeight;
                    } else {
                        margin = -percentY * deltaHeight;
                    }

                    margin = parseInt(margin);

                    innerContent.css({
                        'position': 'relative',
                        'top': margin
                    });
                });
            });
        },

        NavbarHeader: function ($location) {

            // **********************************************************************//
            // ! Get header navbar data
            // **********************************************************************//

            if (!et_global['shop_navbar'] || et_global['w_width'] > 992 && $location != 'fixed') return;

            var navbar = {};

            navbar['out'] = '';

            $('.navbar-header').each(function (e) {

                // ! Get wishlist
                if ($(this).find('.et-wishlist-widget').html() != null) {
                    navbar['wishlist'] = '<div class="' + $(this).find('.et-wishlist-widget').attr('class') + '">';
                    navbar['wishlist'] += $(this).find('.et-wishlist-widget').html();
                    navbar['wishlist'] += '</div>';
                }

                // ! Get search
                if ($(this).find('.header-search').html() != null) {
                    navbar['search'] = '<div class="' + $(this).find('.header-search').attr('class') + '">';
                    navbar['search'] += $(this).find('.header-search').html();
                    navbar['search'] += '</div>';
                }

                // ! Get search for unstandard header types
                if ($.inArray(etOldHeaderConfig['layoutSettings']['header_type'], ['center', 'center3', 'advanced']) > -1 && $(this).parents().find('.header-search').html() != null) {
                    if (!$(this).parents().find('.header-search').parent('.menu')) {
                        navbar['search'] = '<div class="header-search act-full-width">';
                        navbar['search'] += $(this).parents().find('.header-search').html();
                        navbar['search'] += '</div>';
                    }
                }

                // ! Get cart
                if ($(this).find('.shopping-container').html() != null) {
                    navbar['cart'] = '<div class="' + $(this).find('.shopping-container').attr('class') + '">';
                    navbar['cart'] += $(this).find('.shopping-container').html();
                    navbar['cart'] += '</div>';
                }

                // ! Get account
                if ($(this).find('.my-account-link').html() != null) {
                    navbar['account'] = '<div class="' + $(this).find('.my-account-link').attr('class') + '">';
                    navbar['account'] += $(this).find('.my-account-link').html();
                    navbar['account'] += '</div>';
                }

                // ! Get account unlogged
                if ($(this).find('.login-link').html() != null) {
                    navbar['account'] = '<div class="' + $(this).find('.login-link').attr('class') + '">';
                    navbar['account'] += $(this).find('.login-link').html();
                    navbar['account'] += '</div>';
                }

                // ! Get hamburger icon for hamburger header type
                if (etOldHeaderConfig['layoutSettings']['header_type'] == 'hamburger-icon' && $(this).find('.hamburger-icon').html() != null) {
                    navbar['hamburger'] = '<div class="' + $(this).find('.hamburger-icon').attr('class') + '">';
                    navbar['hamburger'] += $(this).find('.hamburger-icon').html();
                    navbar['hamburger'] += '</div>';
                }

            });

            if ($location != 'fixed') $('.navbar-header.show-in-header').remove();

            // ! Create out data
            navbar['out'] += ($location != 'fixed') ? '<div class="navbar-header show-in-header">' : '';
            navbar['out'] += (navbar['search'] != null) ? navbar['search'] : '';
            navbar['out'] += (navbar['account'] != null) ? navbar['account'] : '';
            navbar['out'] += (navbar['wishlist'] != null) ? navbar['wishlist'] : '';
            navbar['out'] += (navbar['cart'] != null) ? navbar['cart'] : '';
            navbar['out'] += (navbar['hamburger'] != null) ? navbar['hamburger'] : '';
            navbar['out'] += ($location != 'fixed') ? '</div>' : '';

            // ! Do it for fixed header
            if ($location == 'fixed') return navbar['out'];

            // ! Do it for mobile menu
            $('header.main-header .navbar-toggle').before(navbar['out']);
        },

        wishlist: function () {
            // **********************************************************************//
            // ! Wishlist
            // **********************************************************************//
            if ($('.et-wishlist-widget').length == 0) return;

            setTimeout(function () {
                $('body').addClass('wishlist-show');
            }, 1000);

            $('.yith-wcwl-add-button.show').each(function () {
                var wishListText = $(this).find('a').text();
                $(this).find('a').attr('data-hover', wishListText);
            });

            var $fragment_refresh = {
                url: etOldHeaderConfig.ajaxurl,
                data: {
                    action: 'etheme_wishlist_fragments'
                },
                method: 'get',
                success: function (data) {
                    setWishlist(data.wishlist);
                }
            };

            function refresh_wishlist_fragment() {
                $.ajax($fragment_refresh);
            }

            $(document.body).bind('added_to_cart added_to_wishlist removed_from_wishlist', function () {
                refresh_wishlist_fragment();
            });

            function setWishlist(wishlist) {
                $('.et-wishlist-widget').replaceWith(wishlist);
            }

            var timeout = 0;

            $(document.body).bind('added_to_wishlist', function () {
                var navbar = $('.header .navbar-header');

                clearTimeout(timeout);

                if (et_global['fixed_header'] && $('.fixed-header').hasClass('fixed-enabled')) {
                    navbar = $('.fixed-header .navbar-header');
                }

                navbar.addClass('wishlist-widget-show');

                timeout = setTimeout(function () {
                    navbar.removeClass('wishlist-widget-show');
                }, 4500);
            });
        },
    };

    $(document).ready(function () {
        oldHeader.init();
    });

})(jQuery);