/**
 * Description
 *
 * @package    ajax-filters.js
 * @since      6.3.4
 * @author     stas
 * @link       http://xstore.8theme.com
 * @license    Themeforest Split Licence
 */
var ajaxFilters;

;(function ($) {

    "use strict";

    var et_ajax;

    ajaxFilters = {
        init: function () {
            et_ajax = {
                'in_progress': false
            };
            this.ajaxFilters();
        },

        ajaxFilters: function () {
            if (etAjaxFiltersConfig.woocommerceSettings.ajax_filters) {
                // ! Most of all filters
                $(document).on('click', '.etheme_swatches_filter ul li a, .woocommerce-widget-layered-nav ul li a, .widget_rating_filter ul li a, .widget_layered_nav_filters ul li a', function (e) {
                    e.preventDefault();
                    if (et_ajax['in_progress']) return;
                    var href = $(this).attr('href');
                    var current = window.location.href;

                    if (!$(this).hasClass('remove-brand') && !$(this).parents('.widget_layered_nav_filters').hasClass('etheme-active-filters')) {
                        if (current.indexOf('filter_brand') > 1) {
                            var url = new URL(current);
                            var params = url.searchParams.get('filter_brand');
                            href = href.replace('?', '?filter_brand=' + params + '&');
                        }
                    }
                    load_data(href);
                });

                // ! Brand filter
                $(document).on('click cnahge', '.etheme_widget_brands_filter ul li a, .dropdown_product_brand', function (e) {
                    e.preventDefault();
                    //var start_time = new Date().getTime();

                    var href = '';

                    if ($(this).hasClass('dropdown_product_brand')) {
                        href = $(this).find('option:selected').data('url');
                        if (!href) {
                            return;
                        }
                    } else {
                        href = $(this).attr('href');
                    }

                    var brand_filter = $(this).parents('.etheme_widget_brands_filter');

                    if (brand_filter.hasClass('on_brand')) {

                        var shop_url = brand_filter.attr('data-shop-url');
                        var params = get_url_params(href);
                        var i = 0;

                        shop_url = shop_url + '?';

                        $.each(params, function (e, t) {
                            i++;
                            if (Object.keys(params).length > i) {
                                shop_url = shop_url + e + "=" + t + '&';
                            } else {
                                shop_url = shop_url + e + "=" + t;
                            }
                        });

                        load_data(shop_url);

                    } else {
                        load_data(href);
                    }
                });

                // ! Reset price filter
                $(document).on('click', '.et-reset-price', function (e) {
                    e.preventDefault();
                    if (et_ajax['in_progress']) return;
                    var form = $(this).parents('.etheme-price-filter form');
                    var min = form.find('#min_price').data('min');
                    var max = form.find('#max_price').data('max');

                    form.find('#min_price').val(min);
                    form.find('#max_price').val(max);

                    $(document.body).trigger('price_slider_slide', [min, max]);

                    $.each($('.etheme-price-filter .ui-slider-handle'), function (i, val) {
                        // if (i != 1) {
                        //     reset_position($(val), false, true);
                        // } else {
                        //     reset_position($(val), true, true);
                        // }
                        reset_position($(val), !(i != 1), true);
                    });

                    reset_position($('.etheme-price-filter .ui-slider-range'), false, false);

                    var action = form.attr('action');
                    var href = action + '?' + form.find('input').not('#min_price, #max_price').serialize();

                    load_data(href);
                });

                // ! Price filter when price set
                $(document).on('price_slider_change', function () {

                    $('.et-reset-price').removeClass('hidden');

                    if (et_ajax['in_progress']) return;

                    var form = $(this).find('.etheme-price-filter form').first();

                    if (!form || form.length < 1) return

                    //$( 'body' ).addClass('ajax-price-progress');

                    var action = form.attr('action');
                    var href = action + '?' + form.serialize();

                    load_data(href);
                });

                // ! Price filter
                $(document).on('click', '.widget_price_filter .button:not(".et-reset-price")', function (e) {
                    e.preventDefault();
                    if (et_ajax['in_progress']) return;
                    var form = $(this).closest('form');
                    var action = form.attr('action');
                    var href = action + '?' + form.serialize();

                    load_data(href);
                });

                // WooCommerce select type filters
                $(document).on('change', 'select.woocommerce-widget-layered-nav-dropdown', function (e) {
                    e.preventDefault();
                    if (et_ajax['in_progress']) return;

                    var $this = $(this),
                        current = window.location.href,
                        calss = $this.attr('class'),
                        filter = '',
                        href = '';

                    calss = calss.split(' ');

                    $.each(calss, function (i, t) {
                        if (t.includes('dropdown_layered_nav_')) {
                            filter = t.replace("dropdown_layered_nav_", "");
                        }
                    });

                    filter = 'filter_' + filter;

                    if (current.includes(filter)) {
                        var old_var = $this.parents('form').find('input[name=' + filter + ']').attr('value');

                        href = current.replace(filter + '=' + old_var, filter + '=' + $this.val());
                    } else {
                        href = current.includes('?') ?
                            current.replace('?', '?' + filter + '=' + $this.val() + '&') :
                            current + '?' + filter + '=' + $this.val();
                    }
                    if (href) {
                        load_data(href);
                    }
                });
            }

            // ! Pagination
            if (etAjaxFiltersConfig.woocommerceSettings.ajax_pagination) {
                $(document).on('click', '.woocommerce-pagination ul li a', function (e) {
                    e.preventDefault();
                    if (et_ajax['in_progress']) return;
                    load_data($(this).attr('href'));
                });
            }

            // ! Get params from url
            function get_url_params(url) {
                var params = {};
                var parser = document.createElement('a');
                parser.href = url;
                var query = parser.search.substring(1);
                var vars = query.split('&');
                for (var i = 0; i < vars.length; i++) {
                    var pair = vars[i].split('=');
                    params[pair[0]] = decodeURIComponent(pair[1]);
                }
                return params;
            }

            // ! Load data
            function load_data(href) {
                $('.et-loader.product-ajax').addClass('loading');
                $('body').addClass('ajax-progress');
                et_ajax['in_progress'] = true;

                var o_href = href;

                o_href = o_href.replace('?et_ajax=true&', '?');
                o_href = o_href.replace('?et_ajax=true', '?');
                o_href = o_href.replace('et_ajax=true&', '');
                o_href = o_href.replace('et_ajax=true', '');

                if (!href.includes('?')) {
                    href = href + '?et_ajax=true';
                } else {
                    href = href.replace('?', '?et_ajax=true&');
                }

                $.ajax({
                    url: href,
                    method: 'GET',
                    timeout: 100000,
                    dataType: 'text',
                    beforeSend: function () {
                        $('.sidebar.et-mini-content.active').removeClass('active');
                        $('.et-toggle-mob-sidebars-wrapper').removeClass('et-content-shown');

                        // var container = $('html, body'),
                        // offsetTop = $(document).find('.content-page').offset().top - 50;
                        // container.animate({
                        //     scrollTop: offsetTop
                        // });
                    },
                    success: function (response) {
                        var products = $(response).find('.products-loop').html(),
                            sidebar = $(response).find('.sidebar').html(),
                            filter = $(response).find('.shop-filters').html(),
                            pagination = $(response).find('.after-shop-loop').html(),
                            empty = $(response).find('.empty-category-block').html();

                        pagination = pagination.replace('?et_ajax=true', '?');
                        pagination = pagination.replace('et_ajax=true', '');

                        var productsBlock = $('.content-page .products-loop'),
                            emptyBlock = $('.content-page .empty-category-block');

                        if (empty) {
                            productsBlock.html('');
                            if (emptyBlock.length) {
                                emptyBlock.html(empty);
                                emptyBlock.removeClass('hidden');
                            } else {
                                productsBlock.after('<div class="empty-category-block">' + empty + '</div>');
                            }
                        } else {
                            emptyBlock.html('').addClass('hidden');
                            productsBlock.html(products);
                        }

                        $('.content-page .sidebar').html(sidebar);

                        $('.content-page .shop-filters').html(filter);

                        // added in v6.2.6
                        // Reinit selectWoo after widgets refresh
                        // if ( jQuery().selectWoo ) {
                        $.each($('select.woocommerce-widget-layered-nav-dropdown'), function () {
                            var $this = $(this);
                            var wc_layered_nav_select = function () {
                                jQuery($this).selectWoo({
                                    minimumResultsForSearch: 5,
                                    width: '100%',
                                    language: {
                                        noResults: function () {
                                            return etAjaxFiltersConfig.notices['noMatchFound'];
                                        }
                                    }
                                });
                            };
                            wc_layered_nav_select();
                        });
                        // }

                        etTheme.categoriesAccordion();

                        if (!pagination) {
                            $('.content-page .after-shop-loop').html('');
                        } else {
                            $('.content-page .after-shop-loop').html(pagination);
                        }

                        window.history.pushState('', '', o_href);
                    },
                    error: function (response) {
                        etTheme.et_notice('ajax-filters', 'error');
                    },
                    complete: function () {
                        $('.et-loader.product-ajax').removeClass('loading');

                        etTheme.reinitSwatches();
                        etTheme.contentProdImages();
                        etTheme.countdown(); // refresh product timers
                        $('body').removeClass('swc-default-done');
                        etTheme.widgetsOpenCloseDefault();
                        reinit_price_filter();

                        etTheme.sidebarMobile();
                        etTheme.stickySidebar();

                        $('body').removeClass('ajax-progress');
                        et_ajax['in_progress'] = false;

                        etTheme.global_image_lazy();

                        var top = $('.content-page .main-products-loop > .products-loop').offset().top;

                        if ($('.content-page .filter-wrap').length)
                            top -= $('.content-page .filter-wrap').outerHeight();

                        // extra space to scroll
                        top -= 110;

                        // added in v6.2.6
                        $('html, body').animate({
                            scrollTop: top
                        }, 1000);

                        // var request_time = new Date().getTime() - start_time;
                        // console.log(request_time);
                        // console.log(convertMS(request_time));
                    }
                });
            }

            // function convertMS( milliseconds ) {
            //     var day, hour, minute, seconds;
            //     seconds = (milliseconds / 1000);
            //     // minute = (seconds / 60);
            //     // seconds = seconds % 60;
            //     // hour = (minute / 60);
            //     // minute = minute % 60;
            //     // day = (hour / 24);
            //     // hour = hour % 24;
            //     return {
            //         // day: day,
            //         // hour: hour,
            //         // minute: minute,
            //         seconds: seconds
            //     };
            // }

            // ! Reinit price filter
            function reinit_price_filter() {
                if ($('.price_slider').length) {
                    // ! woocommerce_price_slider_params is required to continue, ensure the object exists
                    if (typeof woocommerce_price_slider_params === 'undefined') {
                        return false;
                    }

                    $('input#min_price, input#max_price').hide();
                    $('.price_slider, .price_label').show();

                    var min = $('.price_slider_amount #min_price'),
                        max = $('.price_slider_amount #max_price');
                    var min_price = min.data('min'),
                        max_price = max.data('max'),
                        current_min_price = parseInt(min.val() ? min.val() : min_price, 10),
                        current_max_price = parseInt(max.val() ? max.val() : max_price, 10);

                    $('.price_slider').slider({
                        range: true,
                        animate: true,
                        min: min_price,
                        max: max_price,
                        values: [current_min_price, current_max_price],
                        create: function () {

                            min.val(current_min_price);
                            max.val(current_max_price);

                            $(document.body).trigger('price_slider_create', [current_min_price, current_max_price]);
                        },
                        slide: function (event, ui) {
                            $('input#min_price').val(ui.values[0]);
                            $('input#max_price').val(ui.values[1]);

                            $(document.body).trigger('price_slider_slide', [ui.values[0], ui.values[1]]);
                        },
                        change: function (event, ui) {
                            $(document.body).trigger('price_slider_change', [ui.values[0], ui.values[1]]);
                        }
                    });
                }
            };

            // ! Reset price slider width
            function reset_width() {
                var slider_range = $('.etheme-price-filter .ui-slider-range');
                var width = $(slider_range).get(0).style.width;

                if (parseFloat(width) + 0.300 >= 100) {
                    slider_range.css('width', '100%');
                } else {
                    slider_range.css('width', parseFloat(width) + 0.300 + '%');
                }
            }

            // ! Reset price slider position
            function reset_position(elem, type, width) {
                var interval = setInterval(function () {
                    var left = parseFloat(elem.get(0).style.left);

                    if (type) {
                        if (left + 0.300 >= 100) {
                            elem.css('left', '100%');
                            clearInterval(interval);
                        } else {
                            elem.css('left', left + 0.300 + '%');
                        }

                    } else {
                        if (left - 0.300 <= 0) {
                            elem.css('left', 0);
                            clearInterval(interval);
                        } else {
                            elem.css('left', left - 0.300 + '%');
                        }
                    }
                    if (width) reset_width();
                }, 1);
            }
        }

    };

    $(document).ready(function () {
        ajaxFilters.init();
    });

})(jQuery);
