<?php
global $et_loop;

if( empty( $et_loop['columns'] ) ) {
    $et_loop['columns'] = etheme_get_option('blog_columns');
}

if( empty( $et_loop['slider'] ) ) {
    $et_loop['slider'] = false;
}

if( empty( $et_loop['loop'] ) ) {
    $et_loop['loop'] = 0;
}

$options = array();

$options['layout'] = etheme_get_option('blog_layout');

if ( is_single() && $options['layout'] == 'timeline2' ) {
    $et_loop['slide_view'] = $options['layout'];
}

if( ! empty( $et_loop['blog_layout'] ) ) {
    $options['layout'] = $et_loop['blog_layout'];
}

$options['size'] = etheme_get_option( 'blog_images_size' );
$options['hide_img'] = false;

if( ! empty( $et_loop['size'] ) ) {
    $options['size'] = $et_loop['size'];
}

if( ! empty( $et_loop['hide_img'] ) ) {
    $options['hide_img'] = $et_loop['hide_img'];
}

$options['excerpt_length'] = etheme_get_option('excerpt_length');

$et_loop['loop']++;

$options['postClass']      = etheme_post_class( $options['layout'] );
// get permalink before content because if content has products then link is bloken
$options['the_permalink'] = get_the_permalink();

?>

<article <?php post_class( $options['postClass'] ); ?> id="post-<?php the_ID(); ?>">
    <div>
        <?php if ( ! empty( $et_loop['slide_view'] ) && $et_loop['slide_view'] == 'timeline2' ): ?>
            <div class="meta-post-timeline">
                <span class="time-day"><?php the_time('d'); ?></span>
                <span class="time-mon"><?php the_time('M'); ?></span>
            </div>
        <?php endif; 

            if ( !$options['hide_img'] ) { 
                etheme_post_thumb( array('size' => $options['size'], 'in_slider' => $et_loop['slider'] ) ); 
            }
        ?>

        <div class="grid-post-body">
            <div class="post-heading">
                <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                <?php if(etheme_get_option('blog_byline')): ?>
                    <?php etheme_byline( array( 'author' => 0 ) );  ?>
                <?php endif; ?>
            </div>

            <div class="content-article">
                <?php if ( $options['excerpt_length'] > 0 ) {
                    if ( strlen(get_the_excerpt()) > 0 ) {
                        $options['excerpt_length'] = apply_filters( 'excerpt_length', $options['excerpt_length'] );
                        $options['excerpt_more'] = apply_filters( 'excerpt_more', ' ' . '[&hellip;]' );
                        $options['text']         = wp_trim_words( get_the_excerpt(), $options['excerpt_length'], $options['excerpt_more'] );
                        echo apply_filters( 'wp_trim_excerpt', $options['text'], $options['text'] );
                    }
                    else 
                        the_excerpt();
                }  ?>
                <?php etheme_read_more( $options['the_permalink'], true ) ?>
            </div>
        </div>
    </div>
</article>
<?php unset($options); ?>