<?php

/*
 * This file is part of Twig.
 *
 * (c) Fabien Potencier
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace WCML\Twig\Node\Expression\Binary;

use WCML\Twig\Compiler;
class InBinary extends \WCML\Twig\Node\Expression\Binary\AbstractBinary
{
    public function compile(\WCML\Twig\Compiler $compiler)
    {
        $compiler->raw('twig_in_filter(')->subcompile($this->getNode('left'))->raw(', ')->subcompile($this->getNode('right'))->raw(')');
    }
    public function operator(\WCML\Twig\Compiler $compiler)
    {
        return $compiler->raw('in');
    }
}
\class_alias('WCML\\Twig\\Node\\Expression\\Binary\\InBinary', 'WCML\\Twig_Node_Expression_Binary_In');
