<div class="isb_sale_badge <?php echo esc_attr( $isb_class ); ?>" data-id="<?php echo esc_attr( $isb_price['id'] ); ?>">
	<div class="isb_sale_title <?php echo esc_attr( $isb_curr_set['color'] ); ?>">
		<span class="isb_sale_title_text"><?php echo ( isset( $isb_curr_set['special_text'] ) && $isb_curr_set['special_text'] !== '' ? $isb_curr_set['special_text'] : esc_html__( 'On Sale!', 'improved-sale-badges' ) ); ?></span>
	</div>
	<div class="isb_sale_percentage">
		<span class="isb_percentage">
			<?php echo esc_html( $isb_price['percentage'] ); ?>
		</span>
		<span class="isb_percentage_text">
			<?php esc_html_e('%', 'improved-sale-badges' ); ?>
		</span>
	</div>
	<div class="isb_sale_text"><?php esc_html_e('OFF', 'improved-sale-badges' ); ?></div>
	<div class="isb_money_saved">
		<span class="isb_saved_text">
			<?php
				if ( $isb_price['type'] == 'simple' || is_singular( 'product' ) && $isb_price['id'] != 0 ) {
					esc_html_e('Save', 'improved-sale-badges' );
				}
				else {
					esc_html_e('Up to', 'improved-sale-badges' );
				}
			?> 
		</span>
		<span class="isb_saved">
			<?php echo strip_tags( wc_price( $isb_price['difference'] ) ); ?>
		</span>
	</div>
<?php
	if ( isset($isb_price['time']) ) {
?>
	<div class="isb_scheduled_sale isb_scheduled_<?php echo esc_attr( $isb_price['time_mode'] ); ?> <?php echo esc_attr( $isb_curr_set['color'] ); ?>">
		<span class="isb_scheduled_text">
			<?php
				if ( $isb_price['time_mode'] == 'start' ) {
					esc_html_e('Starts in', 'improved-sale-badges' );
				}
				else {
					esc_html_e('Ends in', 'improved-sale-badges' );
				}
			?> 
		</span>
		<span class="isb_scheduled_time">
			<?php echo esc_html( $isb_price['time'] ); ?>
		</span>
	</div>
<?php
	}
?>
</div>