'use strict';
var ET_Elementor_After = (function ($) {

	var $window = $(window);

	return {
		init: function (elementorPreview = false) {
			this.addOtherResponsiveSeizes();
			this.applyDataDeviceMode();
		},
		applyDataDeviceMode: function () {
			$window.on('load', function () {
				jQuery('.elementor-panel-footer-sub-menu div[data-device-mode]').on('click', function () {
					setTimeout(() => {
						jQuery('#elementor-preview-iframe').contents().find('body').attr('data-elementor-device-mode', jQuery(this).attr('data-device-mode'));
					}, 1000);
				});
			});
		},
		addOtherResponsiveSeizes: function () {
			$window.on('load', function () {

				$('#elementor-panel-footer-responsive .elementor-panel-footer-sub-menu div[data-device-mode="desktop"]').after('<div class="elementor-panel-footer-sub-menu-item" data-device-mode="laptop"><i class="elementor-icon eicon-device-laptop" aria-hidden="true"></i><span class="elementor-title">Laptop</span><span class="elementor-description">Prev... for ' + ElementorBreakPoints.laptop + 'px</span></div>');
				$('#elementor-panel-footer-responsive .elementor-panel-footer-sub-menu div[data-device-mode="tablet"]').before('<div class="elementor-panel-footer-sub-menu-item" data-device-mode="tabletlandscape"><i class="elementor-icon eicon-device-tablet rotate-90" aria-hidden="true"></i><span class="elementor-title">Tablet Landscape</span><span class="elementor-description">Prev... for ' + ElementorBreakPoints.tabletlandscape + 'px</span></div>');
				$('.elementor-panel-footer-sub-menu-item[data-device-mode="mobile"]').after('<div class="elementor-panel-footer-sub-menu-item" data-device-mode="smallmobile"><i class="elementor-icon eicon-device-mobile small-icon" aria-hidden="true"></i><span class="elementor-title">Small Mobile</span><span class="elementor-description">Preview for ' + ElementorBreakPoints.smallmobile + 'px</span></div>');
				$('.elementor-panel-footer-sub-menu-item[data-device-mode="mobile"]').find('.elementor-description').html('<span class="elementor-description">Preview for ' + ElementorBreakPoints.mobile + 'px</span>');
				$('.elementor-panel-footer-sub-menu-item[data-device-mode="tablet"]').find('.elementor-description').html('<span class="elementor-description">Preview for ' + ElementorBreakPoints.tablet + 'px</span>');
				$('.elementor-panel-footer-sub-menu-item[data-device-mode]').on('click', function () {
					$(this).parent().find('.elementor-panel-footer-sub-menu-item').each(function () {
						$(this).removeClass('active');
					})
					$(this).addClass('active');
				});
			});
		},
	};
})(jQuery);

// Frontend
jQuery(document).ready(function () {
	ET_Elementor_After.init();
});